# 画面設計書 277-Web IDE

## 概要

本ドキュメントは、GitLabの「Web IDE」画面の設計書です。ブラウザ上でコードを編集・コミットできる統合開発環境（IDE）の画面仕様を記載しています。

### 本画面の処理概要

**業務上の目的・背景**：開発者がローカル環境にGitクライアントや開発ツールをセットアップせずに、ブラウザから直接コードの編集、ファイル作成、コミットを行えるようにします。これにより、軽微な修正やドキュメント更新などを素早く行うことができ、開発の生産性を向上させます。

**画面へのアクセス方法**：プロジェクトのリポジトリ画面やファイル表示画面から「Web IDE」ボタンをクリックしてアクセスします。URLは`/-/ide/project/{namespace}/{project}/edit/{branch}/-/{path}`の形式です。

**主要な操作・処理内容**：
1. ファイルツリーの表示・ナビゲーション
2. コードエディタでのファイル編集（Monaco Editor）
3. 新規ファイルの作成
4. ファイルの削除
5. 変更のステージング
6. コミットの作成
7. マージリクエストの作成（オプション）
8. GitLab Duoとの連携（コード補完等）

**画面遷移**：リポジトリファイル表示画面、マージリクエスト詳細画面などから遷移。コミット完了後はプロジェクトのコミット詳細画面やマージリクエスト作成画面へ遷移可能です。

**権限による表示制御**：プロジェクトの読み取り権限があればWeb IDEにアクセス可能です。プッシュ権限がない場合は、フォークを作成して編集するオプションが表示されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 141 | Web IDE | 主機能 | Web IDEエディタ機能 |
| 16 | ファイル編集 | 補助機能 | ファイル編集処理 |
| 17 | ファイル作成 | 補助機能 | ファイル作成処理 |

## 画面種別

編集（IDE）

## URL/ルーティング

```
GET /-/ide/project/:project_id/edit/:branch/-/:path
GET /-/ide/project/:project_id/merge_requests/:merge_request_id
GET /-/ide
```

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| project_id | 入力（URL） | String | - | プロジェクトのフルパス |
| branch | 入力（URL） | String | - | ブランチ名 |
| path | 入力（URL） | String | - | ファイルパス |
| merge_request_id | 入力（URL） | Integer | - | マージリクエストID |

## 表示項目

### IDE全体構成

| 項目名 | 説明 |
|--------|------|
| ファイルツリー | プロジェクトのファイル・ディレクトリ構造 |
| エディタ領域 | Monaco Editorによるコード編集領域 |
| タブバー | 開いているファイルのタブ |
| ステータスバー | 現在のファイル情報、言語モード |
| コミットパネル | 変更のステージング・コミット |
| 設定パネル | エディタ設定 |

### データ属性（JavaScript用）

| 属性名 | 説明 |
|--------|------|
| new-web-ide-help-page-path | Web IDEヘルプページへのパス |
| sign-in-path | サインインページへのパス |
| sign-out-path | サインアウトパス |
| user-preferences-path | ユーザー設定ページへのパス |
| fork-info | フォーク情報（JSON） |
| branch-name | ブランチ名 |
| file-path | ファイルパス |
| merge-request | マージリクエストID |
| project-path | プロジェクトパス |
| csp-nonce | CSPノンス |
| editor-font | エディタフォント設定（JSON） |
| extension-marketplace-settings | 拡張機能マーケットプレイス設定（JSON） |
| client-id | OAuthクライアントID |
| callback-urls | OAuthコールバックURL |

## イベント仕様

### 1-ファイル編集

**トリガー**: エディタでのファイル内容変更

**処理フロー**:
1. Monaco Editorで変更を検知
2. 変更内容をメモリ上に保持
3. 変更ファイルをステージング領域に追加可能状態にする

### 2-コミット作成

**トリガー**: コミットパネルでコミットボタン押下

**処理フロー**:
1. ステージングされた変更を収集
2. コミットメッセージの入力を確認
3. GraphQL APIを通じてコミット作成
4. 成功時: コミット完了通知、ファイルツリー更新
5. 失敗時: エラーメッセージ表示

### 3-フォーク作成

**トリガー**: プッシュ権限なしでの編集時

**処理フロー**:
1. フォークパス（`fork_path`）が提供されている場合
2. フォーク作成画面へ遷移
3. フォーク完了後、フォークのWeb IDEへリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| コミット作成 | repositories | Git操作 | コミットの作成 |
| マージリクエスト作成 | merge_requests | INSERT | MR作成時 |
| ファイル作成 | repositories | Git操作 | 新規ファイルの追加 |

### テーブル別更新項目詳細

コミット作成時はGitリポジトリへの操作となり、直接的なRDBMS操作は発生しません。マージリクエスト作成時は別途merge_requestsテーブルへの挿入が行われます。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| MSG001 | 情報 | Loading the Web IDE | 読み込み中 |
| MSG002 | エラー | You don't have permission to push to this project | プッシュ権限なし |

## 例外処理

| 例外 | 処理内容 |
|------|---------|
| プロジェクト読み取り権限なし | 404エラーページを表示 |
| プロジェクト削除保留中 | 404エラーページを表示 |
| OAuthアプリケーション未設定 | 404エラーページを表示（oauth_redirectのみ） |
| ブランチ不正 | エラーメッセージを表示 |

## 備考

- Web IDEはVue.jsとMonaco Editorで構築されたSPA
- `fullscreen`レイアウトを使用
- OAuthアプリケーションは`WebIde::DefaultOauthApplication`で管理
- フォーク情報は`fork_info`メソッドで計算
- エディタフォントはGitLab Monoを使用
- 拡張機能マーケットプレイスとの連携サポート
- 内部イベントトラッキング（`web_ide_viewed`）を実装

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Web IDEに渡されるデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ide_helper.rb | `app/helpers/ide_helper.rb` | ide_dataメソッドで渡されるデータ構造 |

**読解のコツ**:
- `ide_data`メソッド（5-21行目）でフロントエンドに渡されるデータを確認
- `extend_ide_data`メソッド（73-90行目）で追加データを確認
- `ide_fonts`メソッド（35-55行目）でフォント設定を確認

#### Step 2: エントリーポイントを理解する

コントローラの処理フローを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ide_controller.rb | `app/controllers/ide_controller.rb` | コントローラの各アクション |

**主要処理フロー**:
1. **10-11行目**: before_actionでプロジェクト読み取り権限とOAuthアプリ確認
2. **24-28行目**: `index`アクションでフォーク情報取得、fullscreenレイアウトで描画
3. **30-37行目**: `oauth_redirect`アクションでOAuth認証リダイレクト
4. **57-69行目**: `fork_info`メソッドでフォーク情報を計算

#### Step 3: ビューを理解する

画面構成を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.html.haml | `app/views/ide/index.html.haml` | Web IDE画面テンプレート |
| 3-2 | _ide_root.html.haml | `app/views/shared/_ide_root.html.haml` | Vue.jsマウントポイント |

**主要処理フロー**:
- **1行目（index）**: ページタイトル設定
- **2行目**: スタイルバンドル読み込み
- **3行目**: ide_dataヘルパーでデータ取得
- **5行目**: shared/ide_rootパーシャルをレンダリング

### プログラム呼び出し階層図

```
IdeController#index
    │
    ├─ authorize_read_project! (before_action)
    │      └─ find_routable!(Project, path)
    │
    ├─ ensure_web_ide_oauth_application! (before_action)
    │      └─ WebIde::DefaultOauthApplication.ensure_oauth_application!
    │
    ├─ fork_info(project, branch)
    │      ├─ can?(current_user, :push_code, project)
    │      ├─ current_user.fork_of(project)
    │      └─ ide_edit_path / ide_fork_and_edit_path
    │
    └─ render layout: 'fullscreen'
           └─ shared/_ide_root.html.haml
                  └─ Vue.js アプリケーション起動
```

### データフロー図

```
[入力]                    [処理]                         [出力]

URLパラメータ ───▶ IdeController#index
(project_id,              │
 branch, path)            ├─▶ @project = find_routable!
                          │
                          ├─▶ @fork_info = fork_info(project, branch)
                          │
                          ├─▶ ide_data(project:, fork_info:, params:)
                          │       │
                          │       └─▶ extend_ide_data(project:)
                          │
                          └─▶ render ───▶ Vue.js SPA
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ide_controller.rb | `app/controllers/ide_controller.rb` | コントローラ | Web IDE表示処理 |
| ide_helper.rb | `app/helpers/ide_helper.rb` | ヘルパー | データ準備 |
| index.html.haml | `app/views/ide/index.html.haml` | ビュー | メイン画面テンプレート |
| _ide_root.html.haml | `app/views/shared/_ide_root.html.haml` | ビュー | Vue.jsマウントポイント |
| default_oauth_application.rb | `app/models/web_ide/default_oauth_application.rb` | モデル | OAuthアプリ管理 |
| web_ide_csp.rb | `app/controllers/concerns/web_ide_csp.rb` | Concern | CSP設定 |
